/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;

public class PreventSleepPower
extends Power {
    private final Predicate<CachedBlockInfo> predicate;
    private final String message;
    private final boolean allowSpawnPoint;

    public PreventSleepPower(PowerType<?> type, PlayerEntity player, Predicate<CachedBlockInfo> predicate, String message, boolean allowSpawnPoint) {
        super(type, player);
        this.predicate = predicate;
        this.message = message;
        this.allowSpawnPoint = allowSpawnPoint;
    }

    public boolean doesPrevent(IWorldReader world, BlockPos pos) {
        CachedBlockInfo cbp = new CachedBlockInfo(world, pos, true);
        return this.predicate.test(cbp);
    }

    public String getMessage() {
        return this.message;
    }

    public boolean doesAllowSpawnPoint() {
        return this.allowSpawnPoint;
    }
}

